/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ModItemListing;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;

public class ModVillagerTrades {
    private static final float BUY = 0.05f;
    private static final float SELL = 0.2f;
    private static final Supplier<class_3853.class_1652[]> RED_MERCHANT_TRADES = Suppliers.memoize(ModVillagerTrades::makeRedMerchantTrades);
    private static final Supplier<class_3853.class_1652[]> CHRISTMAS_SALES = Suppliers.memoize(() -> Arrays.stream(RED_MERCHANT_TRADES.get()).map(WrappedListing::new).toList().toArray(new class_3853.class_1652[0]));
    private static final class_1767[] VIBRANT_COLORS = new class_1767[]{class_1767.field_7952, class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7942, class_1767.field_7964};

    private static class_3853.class_1652[] makeRedMerchantTrades() {
        ArrayList<Object> trades = new ArrayList<Object>();
        if (CommonConfigs.Functional.ROPE_ENABLED.get().booleanValue()) {
            trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.ROPE.get(), 4, 1, 10));
        }
        trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)class_1802.field_8054, 2, 1, 8));
        if (CommonConfigs.Building.COPPER_LANTERN_ENABLED.get().booleanValue()) {
            trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.COPPER_LANTERN.get(), 1, 1, 12));
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.BOMB_ITEM.get(), 1, 3, 8));
            if (CompatHandler.OREGANIZED) {
                trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.BOMB_SPIKY_ITEM.get(), 1, 4, 8));
            }
        }
        trades.add(new StarForEmeraldTrade(2, 8));
        trades.add(new RocketForEmeraldTrade(3, 1, 3, 8));
        trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)class_1802.field_8626, 1, 4, 8));
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            class_1792 i = ModRegistry.ROPE_ARROW_ITEM.get();
            class_1799 stack = new class_1799((class_1935)i);
            stack.method_7974(Math.max(0, stack.method_7936() - 16));
            trades.add(ModVillagerTrades.itemForEmeraldTrade(stack, 4, 6));
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            trades.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.BOMB_BLUE_ITEM.get(), 1, (class_1935)ModRegistry.BOMB_ITEM.get(), 1, 40, 3));
        }
        return trades.toArray(new class_3853.class_1652[0]);
    }

    public static class_3853.class_1652[] getRedMerchantTrades() {
        if (MiscUtils.FESTIVITY.isChristmas()) {
            return CHRISTMAS_SALES.get();
        }
        return RED_MERCHANT_TRADES.get();
    }

    private static ModItemListing itemForEmeraldTrade(class_1935 item, int quantity, int price, int maxTrades) {
        return ModVillagerTrades.itemForEmeraldTrade(new class_1799(item, quantity), price, maxTrades);
    }

    private static ModItemListing itemForEmeraldTrade(class_1799 itemStack, int price, int maxTrades) {
        return new ModItemListing(new class_1799((class_1935)class_1802.field_8687, price), itemStack, maxTrades, 1, 0.05f);
    }

    private static ModItemListing itemForEmeraldTrade(class_1935 item, int quantity, class_1935 additional, int addQuantity, int price, int maxTrades) {
        return new ModItemListing(new class_1799((class_1935)class_1802.field_8687, price), new class_1799(additional, addQuantity), new class_1799(item, quantity), maxTrades, 1, 0.05f);
    }

    private static class_2487 createRandomFireworkStar(class_5819 random, List<class_1781.class_1782> usedShapes) {
        class_2487 tag = new class_2487();
        ArrayList<class_1781.class_1782> possible = new ArrayList<class_1781.class_1782>(List.of(class_1781.class_1782.values()));
        possible.removeAll(usedShapes);
        if (possible.isEmpty()) {
            tag.method_10567("Type", (byte)class_1781.class_1782.values()[random.method_43048(class_1781.class_1782.values().length)].method_7816());
        } else {
            tag.method_10567("Type", (byte)possible.get(random.method_43048(possible.size())).method_7816());
        }
        tag.method_10556("Flicker", random.method_43057() < 0.42f);
        tag.method_10556("Trail", random.method_43057() < 0.42f);
        ArrayList list = Lists.newArrayList();
        int colors = 0;
        do {
            list.add(VIBRANT_COLORS[random.method_43048(VIBRANT_COLORS.length)].method_7790());
        } while (random.method_43057() < 0.42f && ++colors < 9);
        tag.method_10572("Colors", (List)list);
        if (random.method_43056()) {
            ArrayList fadeList = Lists.newArrayList();
            colors = 0;
            do {
                fadeList.add(VIBRANT_COLORS[random.method_43048(VIBRANT_COLORS.length)].method_7790());
            } while (random.method_43057() < 0.42f && ++colors < 9);
            tag.method_10572("FadeColors", (List)fadeList);
        }
        return tag;
    }

    public static void init() {
        RegHelper.registerWanderingTraderTrades((int)2, listings -> {
            if (CommonConfigs.Building.GLOBE_ENABLED.get().booleanValue()) {
                for (int i = 0; i < CommonConfigs.Building.GLOBE_TRADES.get(); ++i) {
                    listings.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.GLOBE_ITEM.get(), 1, 10, 3));
                }
            }
        });
        RegHelper.registerWanderingTraderTrades((int)1, listings -> {
            if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
                for (int i = 0; i < 2; ++i) {
                    listings.add(ModVillagerTrades.itemForEmeraldTrade((class_1935)ModRegistry.FLAX_SEEDS_ITEM.get(), 1, 6, 8));
                }
            }
        });
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17056, (int)3, itemListings -> {
            if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
                itemListings.add(new ModItemListing(new class_1799((class_1935)ModRegistry.FLAX_SEEDS_ITEM.get(), 15), new class_1799((class_1935)class_1802.field_8687), 16, 2, 0.05f));
            }
        });
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17061, (int)1, itemListings -> {
            if (CommonConfigs.Building.ASH_BRICKS_ENABLED.get().booleanValue()) {
                itemListings.add(new ModItemListing(new class_1799((class_1935)class_1802.field_8687), new class_1799((class_1935)ModRegistry.ASH_BRICK_ITEM.get(), 10), 16, 1, 0.05f));
            }
        });
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)5, itemListings -> {
            if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
                itemListings.add(new ModItemListing(new class_1799((class_1935)class_1802.field_8687, 8), new class_1799((class_1935)ModRegistry.ANTIQUE_INK.get()), 16, 30, 0.05f));
            }
        });
        AdventurerMapsHandler.addTradesCallback();
    }

    private record StarForEmeraldTrade(int price, int maxTrades) implements class_3853.class_1652
    {
        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 itemstack = new class_1799((class_1935)class_1802.field_8450);
            itemstack.method_7959("Explosion", (class_2520)ModVillagerTrades.createRandomFireworkStar(random, List.of()));
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    private record RocketForEmeraldTrade(int price, int paper, int rockets, int maxTrades) implements class_3853.class_1652
    {
        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 itemstack = new class_1799((class_1935)class_1802.field_8639, this.rockets);
            class_2487 tag = itemstack.method_7911("Fireworks");
            class_2499 listTag = new class_2499();
            int stars = 0;
            ArrayList<class_1781.class_1782> usedShapes = new ArrayList<class_1781.class_1782>();
            do {
                listTag.add((Object)ModVillagerTrades.createRandomFireworkStar(random, usedShapes));
            } while (random.method_43057() < 0.42f && ++stars < 7);
            tag.method_10567("Flight", (byte)(random.method_43048(3) + 1));
            tag.method_10566("Explosions", (class_2520)listTag);
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), new class_1799((class_1935)class_1802.field_8407, this.paper), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    private record WrappedListing(class_3853.class_1652 original) implements class_3853.class_1652
    {
        private static final PresentBlockTile DUMMY = new PresentBlockTile(class_2338.field_10980, ModRegistry.PRESENTS.get(null).get().method_9564());

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1914 internal = this.original.method_7246(entity, random);
            if (internal == null) {
                return null;
            }
            DUMMY.method_5447(0, internal.method_8250());
            DUMMY.setSender(entity.method_5477().getString());
            DUMMY.setPublic();
            class_1799 stack = DUMMY.getPresentItem((class_1935)ModRegistry.PRESENTS.get(class_1767.values()[random.method_43048(class_1767.values().length)]).get());
            return new class_1914(internal.method_8246(), internal.method_8247(), stack, internal.method_8249(), internal.method_8248(), internal.method_19279(), internal.method_19278(), internal.method_21725());
        }
    }
}

